<?php
/**
 * Plugin Name: REST Yoast Meta for Posts
 * Description: Expose Yoast SEO title & metadesc in REST API for posts.
 * Version: 1.0
 */

add_action('init', function () {
  $meta_keys = [
  '_yoast_wpseo_title',
  '_yoast_wpseo_metadesc',
  '_yoast_wpseo_focuskw', // ✅ frasa kunci utama
];

  foreach ($meta_keys as $key) {
    register_post_meta('post', $key, [
      'type'         => 'string',
      'single'       => true,
      'show_in_rest' => true,
      'auth_callback' => function () {
        return current_user_can('edit_posts');
      }
    ]);
  }
});
