<?php
// ====== CONFIG (EDIT INI) ======
$WP_BASE    = "https://xavian.store";      // tanpa trailing slash
$WP_USER    = "post";                       // username WP
$WP_APP_PASS= "nTzF SxuL crKg 1RqO zSew o49U";         // application password
// ===============================

header("Content-Type: application/json; charset=utf-8");

function wp_request($method, $path, $query = [], $body = null) {
  global $WP_BASE, $WP_USER, $WP_APP_PASS;

  $url = rtrim($WP_BASE, '/') . "/wp-json/wp/v2" . $path;

  if (!empty($query)) {
    $url .= "?" . http_build_query($query);
  }

  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
  curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
  curl_setopt($ch, CURLOPT_USERPWD, $WP_USER . ":" . str_replace(" ", "", $WP_APP_PASS));

  $headers = ["Accept: application/json"];

  if ($body !== null) {
    $json = json_encode($body);
    $headers[] = "Content-Type: application/json";
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
  }

  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

  $resp = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

  if ($resp === false) {
    $err = curl_error($ch);
    curl_close($ch);
    return [ "ok" => false, "code" => 0, "error" => $err ];
  }

  curl_close($ch);
  $data = json_decode($resp, true);

  if ($code >= 200 && $code < 300) {
    return [ "ok" => true, "code" => $code, "data" => $data ];
  }

  return [ "ok" => false, "code" => $code, "error" => $data ?: $resp ];
}

function ensure_term($taxonomy, $name) {
  // cari
  $res = wp_request("GET", "/$taxonomy", ["search" => $name, "per_page" => 100]);
  if ($res["ok"]) {
    foreach ($res["data"] as $t) {
      if (isset($t["name"]) && mb_strtolower(trim($t["name"])) === mb_strtolower(trim($name))) {
        return $t["id"];
      }
    }
  }

  // buat baru
  $create = wp_request("POST", "/$taxonomy", [], ["name" => $name]);
  if ($create["ok"] && isset($create["data"]["id"])) return $create["data"]["id"];

  return null;
}

$raw = file_get_contents("php://input");
$payload = json_decode($raw, true);

$action = $payload["action"] ?? "";
$data   = $payload["data"] ?? [];

try {
  if ($action === "find_draft_by_title") {
    $title = trim($data["title"] ?? "");
    if ($title === "") throw new Exception("title kosong");

    // Cari draft via search, lalu pilih exact match.
    $res = wp_request("GET", "/posts", [
      "search" => $title,
      "status" => "draft",
      "per_page" => 100
    ]);

    if (!$res["ok"]) throw new Exception("WP error: " . json_encode($res["error"]));

    $found = null;
    foreach ($res["data"] as $p) {
      $rendered = html_entity_decode(strip_tags($p["title"]["rendered"] ?? ""));
      if (trim($rendered) === $title) { $found = $p; break; }
    }

    echo json_encode(["ok" => true, "post" => $found]);
    exit;
  }

  if ($action === "get_post") {
    $id = intval($data["id"] ?? 0);
    if ($id <= 0) throw new Exception("id invalid");
    $res = wp_request("GET", "/posts/$id");
    echo json_encode($res);
    exit;
  }

  if ($action === "ensure_terms") {
    $cats = $data["categories"] ?? [];
    $tags = $data["tags"] ?? [];

    $cat_ids = [];
    foreach ($cats as $c) {
      $c = trim($c);
      if ($c === "") continue;
      $id = ensure_term("categories", $c);
      if ($id) $cat_ids[] = $id;
    }

    $tag_ids = [];
    foreach ($tags as $t) {
      $t = trim($t);
      if ($t === "") continue;
      $id = ensure_term("tags", $t);
      if ($id) $tag_ids[] = $id;
    }

    echo json_encode(["ok" => true, "category_ids" => $cat_ids, "tag_ids" => $tag_ids]);
    exit;
  }

  if ($action === "update_post") {
    $id = intval($data["id"] ?? 0);
    if ($id <= 0) throw new Exception("id invalid");

    $body = $data["body"] ?? null;
    if (!is_array($body)) throw new Exception("body invalid");

    $res = wp_request("POST", "/posts/$id", [], $body);
    echo json_encode($res);
    exit;
  }

  echo json_encode(["ok" => false, "error" => "Unknown action"]);
} catch (Exception $e) {
  echo json_encode(["ok" => false, "error" => $e->getMessage()]);
}
